# Code Submission for Unexpected Improvements to Expected Improvement for Bayesian Optimization

We note that the version of BoTorch contained herein has modifications from the open source version of BoTorch, which means it is *crucial to link the included BoTorch version* in a local environment for the code to work correctly.

## LogEI 
First, we provide pointers for the implementations of the LogEI acquisition functions:
1) Analytical Log(C)EI can be found in botorch/botorch/acquisition/analytic.py.
2) qLog(C)EI as well as qLog(C)PI is defined in ./qlogei.py.
3) qLog(C)EHVI is defined in ./qlogehvi.py.

## Experimental Setup
Regarding the experimental setup,
1) experiment_utils.py includes the definitions of the kernel, model, and likelihood of the Gaussian process surrogate models, in addition to providing wrapper functions that allow ready replacement of acquisition functions and different optimization problems.
2) performance_evaluation.py defines helper functions that evaluate the performance of the optimization algorithms, tracking either the best observed objective value or hyper-volume for multi-objective optimization problems.
3) run_one_replication.py defines the basic optimization loop, including initialization with quasi-random Sobol points, as well as the acquisition function optimization using the `generate_candidate` function.